<?php
// config/database.php - Configuración de la base de datos

class Database {
    private $host = 'localhost';
    private $db_name = 'janickec_boleto_feliz';
    private $username = 'janickec_rifas'; // Cambia por tu usuario de MySQL
    private $password = 'e3QyvyKT@2020';     // Cambia por tu contraseña de MySQL
    private $conn;
    
    // Método para obtener la conexión
    public function getConnection() {
        $this->conn = null;
        
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password,
                array(
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                )
            );
        } catch(PDOException $exception) {
            echo "Error de conexión: " . $exception->getMessage();
            die();
        }
        
        return $this->conn;
    }
    
    // Método para cerrar conexión
    public function closeConnection() {
        $this->conn = null;
    }
}

// Funciones de utilidad para la base de datos
class DatabaseHelper {
    private $db;
    private $conn;
    
    public function __construct() {
        $this->db = new Database();
        $this->conn = $this->db->getConnection();
    }
    
    // Obtener configuración del sistema
    public function getConfig() {
        $query = "SELECT * FROM configuracion ORDER BY id DESC LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch();
    }
    
    // Obtener estadísticas de boletos
    public function getEstadisticas() {
        $query = "CALL ObtenerEstadisticas()";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch();
    }
    
    // Obtener boletos disponibles
    public function getBoletosByEstado($estado = 'disponible', $limit = null) {
        $query = "SELECT numero_boleto FROM boletos WHERE estado = :estado ORDER BY numero_boleto";
        if ($limit) {
            $query .= " LIMIT " . $limit;
        }
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
    
    // Verificar si boletos están disponibles
    public function verificarDisponibilidad($numeros) {
        $placeholders = str_repeat('?,', count($numeros) - 1) . '?';
        $query = "SELECT numero_boleto FROM boletos WHERE numero_boleto IN ($placeholders) AND estado = 'disponible'";
        $stmt = $this->conn->prepare($query);
        $stmt->execute($numeros);
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
    
    // Crear cliente
    public function crearCliente($nombre, $whatsapp, $email = null) {
        $query = "INSERT INTO clientes (nombre, whatsapp, email) VALUES (:nombre, :whatsapp, :email)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':whatsapp', $whatsapp);
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        return $this->conn->lastInsertId();
    }
    
    // Crear pedido
    public function crearPedido($cliente_id, $total_boletos, $monto_total) {
        $fecha_limite = date('Y-m-d', strtotime('+3 days'));
        $query = "INSERT INTO pedidos (cliente_id, total_boletos, monto_total, fecha_limite) 
                  VALUES (:cliente_id, :total_boletos, :monto_total, :fecha_limite)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':cliente_id', $cliente_id);
        $stmt->bindParam(':total_boletos', $total_boletos);
        $stmt->bindParam(':monto_total', $monto_total);
        $stmt->bindParam(':fecha_limite', $fecha_limite);
        $stmt->execute();
        return $this->conn->lastInsertId();
    }
    
    // Reservar boletos
    public function reservarBoletos($cliente_id, $pedido_id, $numeros) {
        $numeros_str = implode(',', $numeros);
        $query = "CALL ReservarBoletos(:cliente_id, :pedido_id, :numeros)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':cliente_id', $cliente_id);
        $stmt->bindParam(':pedido_id', $pedido_id);
        $stmt->bindParam(':numeros', $numeros_str);
        return $stmt->execute();
    }
    
    // Obtener cuentas para depósito
    public function getCuentasDeposito() {
        $query = "SELECT * FROM cuentas_deposito WHERE activa = 1";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll();
    }
    
    // Obtener pedido con detalles
    public function getPedidoConDetalles($pedido_id) {
        $query = "SELECT p.*, c.nombre, c.whatsapp, c.email,
                         GROUP_CONCAT(b.numero_boleto ORDER BY b.numero_boleto) as numeros_boletos
                  FROM pedidos p 
                  JOIN clientes c ON p.cliente_id = c.id
                  LEFT JOIN boletos b ON p.id = b.pedido_id
                  WHERE p.id = :pedido_id
                  GROUP BY p.id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':pedido_id', $pedido_id);
        $stmt->execute();
        return $stmt->fetch();
    }
    
    // Generar números aleatorios disponibles
    public function generarNumerosAleatorios($cantidad) {
        $query = "SELECT numero_boleto FROM boletos WHERE estado = 'disponible' ORDER BY RAND() LIMIT :cantidad";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':cantidad', $cantidad, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
    
    // Destructor para cerrar conexión
    public function __destruct() {
        $this->db->closeConnection();
    }
}

// Configuración de sesión
session_start();

// Función para verificar si es admin
function esAdmin() {
    return isset($_SESSION['admin_logged']) && $_SESSION['admin_logged'] === true;
}

// Función para proteger páginas de admin
function requiereAdmin() {
    if (!esAdmin()) {
        header('Location: admin-login.php');
        exit();
    }
}

?>