<?php
// api/boletos.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';

try {
    $db = new DatabaseHelper();
    $action = $_GET['action'] ?? '';
    
    switch ($action) {
        case 'disponibles':
            $limit = isset($_GET['limit']) ? intval($_GET['limit']) : null;
            $boletos = $db->getBoletosByEstado('disponible', $limit);
            
            echo json_encode([
                'success' => true,
                'data' => array_map('intval', $boletos)
            ]);
            break;
            
        case 'aleatorios':
            $cantidad = isset($_GET['cantidad']) ? intval($_GET['cantidad']) : 1;
            
            if ($cantidad < 1 || $cantidad > 100) {
                echo json_encode([
                    'success' => false,
                    'message' => 'La cantidad debe estar entre 1 y 100'
                ]);
                break;
            }
            
            $boletos = $db->generarNumerosAleatorios($cantidad);
            
            if (count($boletos) < $cantidad) {
                echo json_encode([
                    'success' => false,
                    'message' => 'No hay suficientes boletos disponibles'
                ]);
            } else {
                echo json_encode([
                    'success' => true,
                    'data' => array_map('intval', $boletos)
                ]);
            }
            break;
            
        case 'verificar':
            $numeros = isset($_GET['numeros']) ? explode(',', $_GET['numeros']) : [];
            $numeros = array_map('intval', $numeros);
            
            if (empty($numeros)) {
                echo json_encode([
                    'success' => false,
                    'message' => 'No se proporcionaron números para verificar'
                ]);
                break;
            }
            
            $disponibles = $db->verificarDisponibilidad($numeros);
            $noDisponibles = array_diff($numeros, $disponibles);
            
            echo json_encode([
                'success' => true,
                'data' => [
                    'disponibles' => array_map('intval', $disponibles),
                    'no_disponibles' => array_map('intval', $noDisponibles),
                    'todos_disponibles' => empty($noDisponibles)
                ]
            ]);
            break;
            
        default:
            echo json_encode([
                'success' => false,
                'message' => 'Acción no válida'
            ]);
            break;
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error del servidor: ' . $e->getMessage()
    ]);
}
?>