<?php
// api/admin-pedidos.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, PUT');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
requiereAdmin();

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    switch ($method) {
        case 'GET':
            if ($action === 'recent') {
                $limit = intval($_GET['limit'] ?? 20);
                
                $query = "SELECT p.*, c.nombre, c.whatsapp, c.email 
                         FROM pedidos p 
                         JOIN clientes c ON p.cliente_id = c.id 
                         ORDER BY p.created_at DESC 
                         LIMIT :limit";
                         
                $stmt = $conn->prepare($query);
                $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
                $stmt->execute();
                $pedidos = $stmt->fetchAll();
                
                echo json_encode([
                    'success' => true,
                    'data' => $pedidos
                ]);
                
            } elseif ($action === 'detail') {
                $id = intval($_GET['id'] ?? 0);
                
                if ($id <= 0) {
                    echo json_encode([
                        'success' => false,
                        'message' => 'ID de pedido no válido'
                    ]);
                    break;
                }
                
                $dbHelper = new DatabaseHelper();
                $pedido = $dbHelper->getPedidoConDetalles($id);
                
                if ($pedido) {
                    echo json_encode([
                        'success' => true,
                        'data' => $pedido
                    ]);
                } else {
                    echo json_encode([
                        'success' => false,
                        'message' => 'Pedido no encontrado'
                    ]);
                }
                
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Acción no válida'
                ]);
            }
            break;
            
        case 'PUT':
            $input = json_decode(file_get_contents('php://input'), true);
            
            $id = intval($input['id'] ?? 0);
            $accion = $input['accion'] ?? '';
            
            if ($id <= 0) {
                echo json_encode([
                    'success' => false,
                    'message' => 'ID de pedido no válido'
                ]);
                break;
            }
            
            if ($accion === 'confirmar_pago') {
                // Confirmar pago del pedido
                $conn->beginTransaction();
                
                try {
                    // Verificar que el pedido existe y está pendiente
                    $checkQuery = "SELECT estado FROM pedidos WHERE id = :id";
                    $checkStmt = $conn->prepare($checkQuery);
                    $checkStmt->bindParam(':id', $id);
                    $checkStmt->execute();
                    $pedido = $checkStmt->fetch();
                    
                    if (!$pedido) {
                        throw new Exception('Pedido no encontrado');
                    }
                    
                    if ($pedido['estado'] !== 'pendiente') {
                        throw new Exception('El pedido ya fue procesado');
                    }
                    
                    // Confirmar venta usando procedimiento almacenado
                    $confirmQuery = "CALL ConfirmarVenta(:pedido_id)";
                    $confirmStmt = $conn->prepare($confirmQuery);
                    $confirmStmt->bindParam(':pedido_id', $id);
                    $confirmStmt->execute();
                    
                    $conn->commit();
                    
                    echo json_encode([
                        'success' => true,
                        'message' => 'Pago confirmado exitosamente'
                    ]);
                    
                } catch (Exception $e) {
                    $conn->rollback();
                    echo json_encode([
                        'success' => false,
                        'message' => 'Error al confirmar el pago: ' . $e->getMessage()
                    ]);
                }
                
            } elseif ($accion === 'cancelar') {
                // Cancelar pedido
                $conn->beginTransaction();
                
                try {
                    // Verificar que el pedido existe
                    $checkQuery = "SELECT estado FROM pedidos WHERE id = :id";
                    $checkStmt = $conn->prepare($checkQuery);
                    $checkStmt->bindParam(':id', $id);
                    $checkStmt->execute();
                    $pedido = $checkStmt->fetch();
                    
                    if (!$pedido) {
                        throw new Exception('Pedido no encontrado');
                    }
                    
                    if ($pedido['estado'] === 'pagado') {
                        throw new Exception('No se puede cancelar un pedido ya pagado');
                    }
                    
                    // Liberar boletos reservados
                    $liberarQuery = "UPDATE boletos SET 
                                    estado = 'disponible', 
                                    pedido_id = NULL, 
                                    cliente_id = NULL, 
                                    fecha_reserva = NULL 
                                    WHERE pedido_id = :id";
                    $liberarStmt = $conn->prepare($liberarQuery);
                    $liberarStmt->bindParam(':id', $id);
                    $liberarStmt->execute();
                    
                    // Marcar pedido como cancelado
                    $cancelarQuery = "UPDATE pedidos SET estado = 'cancelado' WHERE id = :id";
                    $cancelarStmt = $conn->prepare($cancelarQuery);
                    $cancelarStmt->bindParam(':id', $id);
                    $cancelarStmt->execute();
                    
                    $conn->commit();
                    
                    echo json_encode([
                        'success' => true,
                        'message' => 'Pedido cancelado exitosamente'
                    ]);
                    
                } catch (Exception $e) {
                    $conn->rollback();
                    echo json_encode([
                        'success' => false,
                        'message' => 'Error al cancelar el pedido: ' . $e->getMessage()
                    ]);
                }
                
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Acción no válida'
                ]);
            }
            break;
            
        default:
            echo json_encode([
                'success' => false,
                'message' => 'Método no permitido'
            ]);
            break;
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error del servidor: ' . $e->getMessage()
    ]);
}
?>
                