<?php
// api/admin-cuentas.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
requiereAdmin();

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    switch ($method) {
        case 'GET':
            if ($action === 'list') {
                // Listar todas las cuentas
                $query = "SELECT * FROM cuentas_deposito ORDER BY created_at DESC";
                $stmt = $conn->prepare($query);
                $stmt->execute();
                $cuentas = $stmt->fetchAll();
                
                echo json_encode([
                    'success' => true,
                    'data' => $cuentas
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Acción no válida'
                ]);
            }
            break;
            
        case 'POST':
            // Agregar nueva cuenta
            $input = json_decode(file_get_contents('php://input'), true);
            
            $banco = trim($input['banco'] ?? '');
            $numeroCuenta = trim($input['numero_cuenta'] ?? '');
            $titular = trim($input['titular'] ?? '');
            $tipoCuenta = $input['tipo_cuenta'] ?? 'ahorros';
            
            if (empty($banco) || empty($numeroCuenta) || empty($titular)) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Todos los campos son requeridos'
                ]);
                break;
            }
            
            if (!in_array($tipoCuenta, ['ahorros', 'corriente'])) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Tipo de cuenta no válido'
                ]);
                break;
            }
            
            // Verificar si la cuenta ya existe
            $checkQuery = "SELECT COUNT(*) FROM cuentas_deposito 
                          WHERE banco = :banco AND numero_cuenta = :numero_cuenta";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->bindParam(':banco', $banco);
            $checkStmt->bindParam(':numero_cuenta', $numeroCuenta);
            $checkStmt->execute();
            
            if ($checkStmt->fetchColumn() > 0) {
                echo json_encode([
                    'success' => false,
                    'message' => 'Esta cuenta ya está registrada'
                ]);
                break;
            }
            
            $query = "INSERT INTO cuentas_deposito (banco, numero_cuenta, titular, tipo_cuenta) 
                     VALUES (:banco, :numero_cuenta, :titular, :tipo_cuenta)";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':banco', $banco);
            $stmt->bindParam(':numero_cuenta', $numeroCuenta);
            $stmt->bindParam(':titular', $titular);
            $stmt->bindParam(':tipo_cuenta', $tipoCuenta);
            
            if ($stmt->execute()) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Cuenta agregada exitosamente',
                    'data' => ['id' => $conn->lastInsertId()]
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Error al agregar la cuenta'
                ]);
            }
            break;
            
        case 'PUT':
            // Actualizar estado de cuenta
            $input = json_decode(file_get_contents('php://input'), true);
            
            $id = intval($input['id'] ?? 0);
            $activa = $input['activa'] ?? true;
            
            if ($id <= 0) {
                echo json_encode([
                    'success' => false,
                    'message' => 'ID de cuenta no válido'
                ]);
                break;
            }
            
            $query = "UPDATE cuentas_deposito SET activa = :activa WHERE id = :id";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':activa', $activa, PDO::PARAM_BOOL);
            $stmt->bindParam(':id', $id);
            
            if ($stmt->execute() && $stmt->rowCount() > 0) {
                echo json_encode([
                    'success' => true,
                    'message' => 'Estado de cuenta actualizado'
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Error al actualizar la cuenta o cuenta no encontrada'
                ]);
            }
            break;
            
        default:
            echo json_encode([
                'success' => false,
                'message' => 'Método no permitido'
            ]);
            break;
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error del servidor: ' . $e->getMessage()
    ]);
}
?>