<?php
// api/admin-config.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
requiereAdmin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'success' => false,
        'message' => 'Método no permitido'
    ]);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $totalBoletos = intval($input['total_boletos'] ?? 0);
    $precioBoleto = floatval($input['precio_boleto'] ?? 0);
    $nombreRifa = trim($input['nombre_rifa'] ?? '');
    $fechaSorteo = $input['fecha_sorteo'] ?? null;
    $estadoRifa = $input['estado_rifa'] ?? 'activa';
    
    // Validaciones
    if ($totalBoletos < 1000 || $totalBoletos > 10000) {
        echo json_encode([
            'success' => false,
            'message' => 'El total de boletos debe estar entre 1,000 y 10,000'
        ]);
        exit;
    }
    
    if ($precioBoleto < 0.50 || $precioBoleto > 100) {
        echo json_encode([
            'success' => false,
            'message' => 'El precio debe estar entre $0.50 y $100.00'
        ]);
        exit;
    }
    
    if (empty($nombreRifa)) {
        echo json_encode([
            'success' => false,
            'message' => 'El nombre de la rifa es requerido'
        ]);
        exit;
    }
    
    if (!in_array($estadoRifa, ['activa', 'pausada', 'finalizada'])) {
        echo json_encode([
            'success' => false,
            'message' => 'Estado de rifa no válido'
        ]);
        exit;
    }
    
    $db = new Database();
    $conn = $db->getConnection();
    
    // Actualizar configuración
    $query = "UPDATE configuracion SET 
              total_boletos = :total_boletos,
              precio_boleto = :precio_boleto,
              nombre_rifa = :nombre_rifa,
              fecha_sorteo = :fecha_sorteo,
              estado_rifa = :estado_rifa,
              updated_at = NOW()
              WHERE id = 1";
    
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':total_boletos', $totalBoletos);
    $stmt->bindParam(':precio_boleto', $precioBoleto);
    $stmt->bindParam(':nombre_rifa', $nombreRifa);
    $stmt->bindParam(':fecha_sorteo', $fechaSorteo);
    $stmt->bindParam(':estado_rifa', $estadoRifa);
    
    if ($stmt->execute()) {
        // Si se cambió el total de boletos, ajustar la tabla de boletos
        $dbHelper = new DatabaseHelper();
        $configActual = $dbHelper->getConfig();
        
        if ($totalBoletos != $configActual['total_boletos']) {
            // Eliminar boletos extras o agregar nuevos según sea necesario
            if ($totalBoletos > $configActual['total_boletos']) {
                // Agregar boletos nuevos
                $inicio = $configActual['total_boletos'] + 1;
                $insertQuery = "INSERT IGNORE INTO boletos (numero_boleto) VALUES ";
                $values = [];
                
                for ($i = $inicio; $i <= $totalBoletos; $i++) {
                    $values[] = "($i)";
                }
                
                $insertQuery .= implode(',', $values);
                $conn->exec($insertQuery);
            } else {
                // Eliminar boletos extras (solo los disponibles)
                $deleteQuery = "DELETE FROM boletos 
                               WHERE numero_boleto > :total_boletos 
                               AND estado = 'disponible'";
                $deleteStmt = $conn->prepare($deleteQuery);
                $deleteStmt->bindParam(':total_boletos', $totalBoletos);
                $deleteStmt->execute();
            }
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'Configuración actualizada exitosamente'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Error al actualizar la configuración'
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error del servidor: ' . $e->getMessage()
    ]);
}
?>